/*
fullscreenFarQuad.glsl
This shader expects 4 vertices to paint a fullscreen quad (actual input is irrelevant).
The depth of the quad is set to the far plane.
*/
#version 430

out VSOut {
	vec2 uv;
} vsoutput;

void main() {
	//Hard coded quad
	const vec2 position[4] = vec2[4](vec2(-1.0, -1.0), vec2(+1.0, -1.0), vec2(-1.0, +1.0), vec2(+1.0, +1.0));
	vsoutput.uv = position[gl_VertexID]*0.5 + 0.5;
	gl_Position = vec4(position[gl_VertexID],1,1);
	
}